/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.report.ReportUtilities;
import cz.insophy.inplan.util.StackedBarColumnTpModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StackedBarTpModel {
    private List<StackedBarColumnTpModel> columns = new ArrayList<StackedBarColumnTpModel>();
    private double staticSize = -1.0;
    private int cardinality = 1;

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public boolean isStaticSizeSet() {
        return this.staticSize >= 0.0;
    }

    public long getMinStartDate() {
        if (this.columns.size() < 1) {
            return -9223372036854775708L;
        }
        long min2 = Long.MAX_VALUE;
        for (StackedBarColumnTpModel c : this.columns) {
            if (c.getStartDate() >= min2) continue;
            min2 = c.getStartDate();
        }
        return min2;
    }

    public long getMaxEndDate() {
        if (this.columns.size() < 1) {
            return -9223372036854775708L;
        }
        long max = Long.MIN_VALUE;
        for (StackedBarColumnTpModel c : this.columns) {
            if (c.getEndDate() <= max) continue;
            max = c.getEndDate();
        }
        return max;
    }

    public double getMaxSize() {
        if (this.staticSize >= 0.0) {
            return this.staticSize;
        }
        double max = 0.0;
        for (StackedBarColumnTpModel c : this.columns) {
            if (!(c.getTotalSize() > max)) continue;
            max = c.getTotalSize();
        }
        return max;
    }

    public double getMaxSize(long viewStart, long viewEnd) {
        if (this.staticSize >= 0.0) {
            return this.staticSize;
        }
        double max = 0.0;
        for (StackedBarColumnTpModel c : this.columns) {
            if (c.getStartDate() > viewEnd) break;
            if (c.getStartDate() < viewStart || !(c.getTotalSize() > max)) continue;
            max = c.getTotalSize();
        }
        return max;
    }

    public boolean overlapsWithAnyColumn(long startDate, long endDate) {
        for (StackedBarColumnTpModel c : this.columns) {
            if (ReportUtilities.getOverlap(startDate, endDate, c.getStartDate(), c.getEndDate()) == 0L) continue;
            return true;
        }
        return false;
    }

    public List<StackedBarColumnTpModel> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public void addColumn(StackedBarColumnTpModel c) {
        Preconditions.checkArgument(c.getTotalSize() >= 0.0);
        Preconditions.checkArgument(!this.columns.contains(c));
        Preconditions.checkArgument(!this.overlapsWithAnyColumn(c.getStartDate(), c.getEndDate()));
        this.columns.add(c);
        this.onColumnAdded(c);
    }

    public void removeColumn(StackedBarColumnTpModel c) {
        Preconditions.checkArgument(this.columns.contains(c));
        this.columns.remove(c);
        this.onColumnRemoved(c);
    }

    public void clearColumns() {
        this.columns.clear();
        this.onColumnsCleared();
    }

    public StackedBarColumnTpModel getColumnAt(long time) {
        for (StackedBarColumnTpModel c : this.columns) {
            if (c.getStartDate() > time) break;
            if (c.getStartDate() > time || c.getEndDate() <= time) continue;
            return c;
        }
        return null;
    }

    public void setDynamicSize() {
        this.staticSize = -1.0;
    }

    public void setStaticSize(double size) {
        Preconditions.checkArgument(size >= 0.0);
        this.staticSize = size;
    }

    public void mergeColumns(StackedBarTpModel modelToMerge) {
        ++this.cardinality;
        if (modelToMerge.isEmpty()) {
            return;
        }
        for (StackedBarColumnTpModel c : modelToMerge.columns) {
            StackedBarColumnTpModel targetColumn = this.getColumnAt(c.getStartDate());
            if (targetColumn == null) continue;
            Preconditions.checkState(targetColumn.getStartDate() == c.getStartDate());
            Preconditions.checkState(targetColumn.getEndDate() == c.getEndDate());
            targetColumn.mergeFloors(c);
        }
    }

    public int getCardinality() {
        return this.cardinality;
    }

    protected void onColumnAdded(StackedBarColumnTpModel c) {
    }

    protected void onColumnRemoved(StackedBarColumnTpModel c) {
    }

    protected void onColumnsCleared() {
    }
}

